// 3D Modeling Courses Website - Version 3 (HTML/CSS/JS) - Futuristic Tech Design

const programs = {
  blender: {
    name: 'Blender',
    gradient: 'linear-gradient(135deg, #F57900 0%, #FF9500 100%)',
    color: '#F57900',
    instructor: 'Алексей Волков'
  },
  maya: {
    name: 'Maya',
    gradient: 'linear-gradient(135deg, #00D9FF 0%, #7C3AED 100%)',
    color: '#00D9FF',
    instructor: 'Мария Соколова'
  },
  '3dsmax': {
    name: '3ds Max',
    gradient: 'linear-gradient(135deg, #7C3AED 0%, #F59E0B 100%)',
    color: '#7C3AED',
    instructor: 'Дмитрий Новиков'
  },
  zbrush: {
    name: 'ZBrush',
    gradient: 'linear-gradient(135deg, #F59E0B 0%, #00D9FF 100%)',
    color: '#F59E0B',
    instructor: 'Елена Петрова'
  }
}

let currentSlide = 0
let slides = []
let dots = []
let slideInterval
let selectedProgram = ''

function initPage() {
  const currentPage = window.location.pathname.includes('enroll.html') ? 'enroll' : 'index'
  
  if (currentPage === 'enroll') {
    initEnrollPage()
  } else {
    initIndexPage()
  }
  
  initSlider()
}

function initIndexPage() {
  loadProjects()
  updateStats()
  
  setInterval(() => {
    loadProjects()
    updateStats()
  }, 500)
}

function loadProjects() {
  const saved = localStorage.getItem('model3dProjects')
  let projects = []
  
  if (saved) {
    try {
      projects = JSON.parse(saved)
    } catch (e) {
      projects = []
    }
  } else {
    projects = [
      {
        id: 1,
        course: 'Blender для начинающих',
        instructor: 'Алексей Волков',
        submissionDate: '2025-03-28',
        rating: 5,
        progress: 85
      },
      {
        id: 2,
        course: 'Maya Advanced',
        instructor: 'Мария Соколова',
        submissionDate: '2025-03-25',
        rating: 5,
        progress: 92
      },
      {
        id: 3,
        course: '3ds Max Профессионал',
        instructor: 'Дмитрий Новиков',
        submissionDate: '2025-03-22',
        rating: 4,
        progress: 78
      }
    ]
    localStorage.setItem('model3dProjects', JSON.stringify(projects))
  }
  
  const heroStats = document.getElementById('heroStats')
  if (heroStats && projects.length > 0) {
    const avgRating = (projects.reduce((sum, p) => sum + p.rating, 0) / projects.length).toFixed(1)
    heroStats.innerHTML = `
      <div class="hero-tech-stat">
        <img src="icons/icon-code.svg" alt="Code" width="20" height="20">
        <span>${projects.length} проектов</span>
      </div>
      <div class="hero-tech-stat">
        <img src="icons/icon-star-fill.svg" alt="Star" width="20" height="20">
        <span>${avgRating} рейтинг</span>
      </div>
    `
  }
  
  const statsTech = document.getElementById('statsTech')
  if (statsTech) {
    const totalProjects = projects.length
    const avgRating = projects.length > 0 ? (projects.reduce((sum, p) => sum + p.rating, 0) / projects.length).toFixed(1) : 0
    const totalProgress = projects.length > 0 ? Math.round(projects.reduce((sum, p) => sum + p.progress, 0) / projects.length) : 0
    const completedProjects = projects.filter(p => p.progress === 100).length
    
    statsTech.innerHTML = `
      <div class="stat-tech-card">
        <div class="stat-tech-icon" style="background: linear-gradient(135deg, #00D9FF 0%, #7C3AED 100%);">
          <img src="icons/icon-box.svg" alt="Box" width="40" height="40">
          <div class="stat-tech-icon-glow"></div>
        </div>
        <div class="stat-tech-content">
          <div class="stat-tech-value">${totalProjects}</div>
          <div class="stat-tech-label">Проектов</div>
        </div>
        <div class="stat-tech-corner"></div>
      </div>
      <div class="stat-tech-card">
        <div class="stat-tech-icon" style="background: linear-gradient(135deg, #7C3AED 0%, #F59E0B 100%);">
          <img src="icons/icon-star-fill.svg" alt="Star" width="40" height="40">
          <div class="stat-tech-icon-glow"></div>
        </div>
        <div class="stat-tech-content">
          <div class="stat-tech-value">${avgRating}</div>
          <div class="stat-tech-label">Рейтинг</div>
        </div>
        <div class="stat-tech-corner"></div>
      </div>
      <div class="stat-tech-card">
        <div class="stat-tech-icon" style="background: linear-gradient(135deg, #00D9FF 0%, #F59E0B 100%);">
          <img src="icons/icon-trending-up.svg" alt="Trending" width="40" height="40">
          <div class="stat-tech-icon-glow"></div>
        </div>
        <div class="stat-tech-content">
          <div class="stat-tech-value">${totalProgress}%</div>
          <div class="stat-tech-label">Прогресс</div>
        </div>
        <div class="stat-tech-corner"></div>
      </div>
      <div class="stat-tech-card">
        <div class="stat-tech-icon" style="background: linear-gradient(135deg, #F59E0B 0%, #7C3AED 100%);">
          <img src="icons/icon-award.svg" alt="Award" width="40" height="40">
          <div class="stat-tech-icon-glow"></div>
        </div>
        <div class="stat-tech-content">
          <div class="stat-tech-value">${completedProjects}</div>
          <div class="stat-tech-label">Завершено</div>
        </div>
        <div class="stat-tech-corner"></div>
      </div>
    `
  }
  
  const projectsGrid = document.getElementById('projectsGrid')
  if (projectsGrid) {
    if (projects.length === 0) {
      projectsGrid.innerHTML = `
        <div class="empty-tech">
          <div class="empty-tech-icon">
            <img src="icons/icon-box.svg" alt="Box" width="80" height="80">
            <div class="empty-tech-rings"></div>
          </div>
          <h3 class="empty-tech-title">Начните свой путь в 3D</h3>
          <p class="empty-tech-text">Запишитесь на курс и увидите свой первый проект здесь</p>
        </div>
      `
    } else {
      projectsGrid.innerHTML = projects.map((project, index) => {
        const stars = Array.from({ length: 5 }, (_, i) => 
          `<img src="icons/icon-star${i < project.rating ? '-fill' : ''}.svg" alt="Star" width="18" height="18" style="color: ${i < project.rating ? '#F59E0B' : 'rgba(0, 217, 255, 0.3)'}">`
        ).join('')
        
        const date = new Date(project.submissionDate).toLocaleDateString('ru-RU', { 
          day: 'numeric', 
          month: 'long', 
          year: 'numeric' 
        })
        
        const gradient = index % 3 === 0 ? 'linear-gradient(135deg, #00D9FF 0%, #7C3AED 100%)' :
          index % 3 === 1 ? 'linear-gradient(135deg, #7C3AED 0%, #F59E0B 100%)' :
          'linear-gradient(135deg, #00D9FF 0%, #F59E0B 100%)'
        
        return `
          <div class="project-tech-card">
            <div class="project-tech-header">
              <div class="project-tech-badge" style="background: ${gradient}">
                ${project.course.split(' ')[0]}
              </div>
              <div class="project-tech-rating">${stars}</div>
            </div>
            <h3 class="project-tech-course">${project.course}</h3>
            <div class="project-tech-details">
              <div class="project-tech-detail">
                <img src="icons/icon-users.svg" alt="User" width="18" height="18">
                <span>${project.instructor}</span>
              </div>
              <div class="project-tech-detail">
                <img src="icons/icon-calendar.svg" alt="Calendar" width="18" height="18">
                <span>${date}</span>
              </div>
            </div>
            <div class="project-tech-progress">
              <div class="project-tech-progress-header">
                <span class="progress-label">Прогресс</span>
                <span class="progress-value">${project.progress}%</span>
              </div>
              <div class="project-tech-progress-bar">
                <div class="project-tech-progress-fill" style="width: ${project.progress}%; background: ${gradient};"></div>
              </div>
            </div>
            <div class="project-tech-glow"></div>
          </div>
        `
      }).join('')
    }
  }
}

function updateStats() {
  // Stats are updated in loadProjects
}

function initEnrollPage() {
  const programCards = document.querySelectorAll('.program-tech-card')
  programCards.forEach(card => {
    card.addEventListener('click', () => {
      const program = card.dataset.program
      selectProgram(program)
    })
  })
  
  const form = document.getElementById('enrollForm')
  if (form) {
    form.addEventListener('submit', handleSubmit)
  }
  
  const startDateInput = document.getElementById('startDate')
  if (startDateInput) {
    const today = new Date()
    const maxDate = new Date(today.getTime() + 90 * 24 * 60 * 60 * 1000)
    startDateInput.min = today.toISOString().split('T')[0]
    startDateInput.max = maxDate.toISOString().split('T')[0]
    startDateInput.addEventListener('change', updateSubmitButton)
  }
}

function selectProgram(programId) {
  selectedProgram = programId
  
  const programCards = document.querySelectorAll('.program-tech-card')
  programCards.forEach(card => {
    if (card.dataset.program === programId) {
      card.classList.add('selected')
      const program = programs[programId]
      card.style.background = program.gradient
      card.style.borderColor = program.color
      const name = card.querySelector('.program-tech-name')
      const desc = card.querySelector('.program-tech-description')
      if (name) name.style.color = 'white'
      if (desc) desc.style.color = 'rgba(255, 255, 255, 0.9)'
      const iconWrapper = card.querySelector('.program-tech-icon-wrapper')
      if (iconWrapper) {
        iconWrapper.style.background = 'rgba(255, 255, 255, 0.2)'
        iconWrapper.style.borderColor = 'rgba(255, 255, 255, 0.4)'
      }
      const glow = card.querySelector('.program-tech-glow')
      if (glow) glow.style.opacity = '1'
    } else {
      card.classList.remove('selected')
      card.style.background = 'rgba(26, 31, 58, 0.6)'
      card.style.borderColor = 'rgba(0, 217, 255, 0.2)'
      const name = card.querySelector('.program-tech-name')
      const desc = card.querySelector('.program-tech-description')
      if (name) name.style.color = 'var(--text)'
      if (desc) desc.style.color = 'var(--text-light)'
      const iconWrapper = card.querySelector('.program-tech-icon-wrapper')
      if (iconWrapper) {
        iconWrapper.style.background = 'rgba(255, 255, 255, 0.1)'
        iconWrapper.style.borderColor = 'rgba(0, 217, 255, 0.3)'
      }
      const glow = card.querySelector('.program-tech-glow')
      if (glow) glow.style.opacity = '0'
    }
  })
  
  const dateSection = document.getElementById('dateSection')
  if (dateSection) {
    dateSection.style.display = 'block'
  }
  
  updateSubmitButton()
}

function updateSubmitButton() {
  const submitBtn = document.getElementById('submitBtn')
  const startDate = document.getElementById('startDate')
  if (submitBtn && startDate) {
    if (selectedProgram && startDate.value) {
      submitBtn.disabled = false
    } else {
      submitBtn.disabled = true
    }
  }
}

function handleSubmit(e) {
  e.preventDefault()
  
  const startDate = document.getElementById('startDate')
  if (!startDate || !startDate.value) {
    return
  }
  
  const saved = localStorage.getItem('model3dProjects')
  const projects = saved ? JSON.parse(saved) : []
  
  const program = programs[selectedProgram]
  const instructor = program ? program.instructor : 'Преподаватель'
  
  const newProject = {
    id: Date.now(),
    course: program ? program.name : 'Курс',
    instructor: instructor,
    submissionDate: startDate.value,
    rating: 0,
    progress: 0
  }
  
  projects.push(newProject)
  localStorage.setItem('model3dProjects', JSON.stringify(projects))
  
  const successMessage = document.getElementById('successMessage')
  if (successMessage) {
    successMessage.style.display = 'flex'
    setTimeout(() => {
      window.location.href = 'index.html'
    }, 2000)
  }
}

function initSlider() {
  slides = Array.from(document.querySelectorAll('.slide'))
  dots = Array.from(document.querySelectorAll('.dot'))
  
  if (slides.length === 0) return
  
  const sliderPrev = document.getElementById('sliderPrev')
  const sliderNext = document.getElementById('sliderNext')
  
  if (sliderPrev) {
    sliderPrev.addEventListener('click', () => {
      goToSlide((currentSlide - 1 + slides.length) % slides.length)
    })
  }
  
  if (sliderNext) {
    sliderNext.addEventListener('click', () => {
      goToSlide((currentSlide + 1) % slides.length)
    })
  }
  
  dots.forEach((dot, index) => {
    dot.addEventListener('click', () => {
      goToSlide(index)
    })
  })
  
  startSlider()
}

function goToSlide(index) {
  currentSlide = index
  
  slides.forEach((slide, i) => {
    slide.classList.toggle('active', i === index)
  })
  
  dots.forEach((dot, i) => {
    dot.classList.toggle('active', i === index)
  })
  
  clearInterval(slideInterval)
  startSlider()
}

function startSlider() {
  slideInterval = setInterval(() => {
    goToSlide((currentSlide + 1) % slides.length)
  }, 3000)
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', initPage)

